<?php
namespace App\Controllers;

use App\Core\Controller;

class MediaController extends Controller
{
    public function listing(array $params): void
    {
        $id = basename($params['id'] ?? '');
        $file = basename($params['file'] ?? '');
        $path = $this->storage->path('listings/' . $id . '/images/' . $file);
        $this->serve($path);
    }

    public function avatar(array $params): void
    {
        $id = basename($params['id'] ?? '');
        $file = basename($params['file'] ?? '');
        $path = $this->storage->path('users/' . $id . '/avatar/' . $file);
        $this->serve($path);
    }

    private function serve(string $path): void
    {
        if (!is_file($path)) {
            http_response_code(404);
            exit('not found');
        }
        $mime = mime_content_type($path) ?: 'application/octet-stream';
        header('Content-Type: ' . $mime);
        header('Cache-Control: public, max-age=86400');
        readfile($path);
        exit;
    }
}
