<?php
namespace App\Core;

class Validator
{
    private array $errors = [];

    public function required(string $field, $value, string $message): self
    {
        if ($value === null || $value === '') {
            $this->errors[$field] = $message;
        }
        return $this;
    }

    public function email(string $field, ?string $value, string $message): self
    {
        if ($value && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
            $this->errors[$field] = $message;
        }
        return $this;
    }

    public function min(string $field, ?string $value, int $min, string $message): self
    {
        if ($value !== null && mb_strlen($value) < $min) {
            $this->errors[$field] = $message;
        }
        return $this;
    }

    public function numeric(string $field, $value, string $message): self
    {
        if ($value !== null && $value !== '' && !is_numeric($value)) {
            $this->errors[$field] = $message;
        }
        return $this;
    }

    public function errors(): array
    {
        return $this->errors;
    }

    public function fails(): bool
    {
        return !empty($this->errors);
    }
}
