<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias" class="active"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-folder-tree"></i> Categorías</h1>
    </div>

    <div class="admin-card">
      <h3><i class="fas fa-plus"></i> Agregar categoría</h3>
      <form method="post" style="display:flex;gap:.8rem;align-items:end;margin-top:1rem;flex-wrap:wrap">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group" style="flex:1;min-width:200px">
          <label class="form-label">Nombre</label>
          <input name="name" placeholder="Ej: Electrodomésticos" required>
        </div>
        <button type="submit"><i class="fas fa-plus"></i> Agregar</button>
      </form>
    </div>

    <div class="admin-card" style="margin-top:1rem">
      <h3>Categorías existentes (<?= count($categories) ?>)</h3>
      <div class="data-list" style="margin-top:1rem">
        <?php foreach($categories as $c): ?>
        <div class="data-item">
          <div class="data-item-body" style="display:flex;justify-content:space-between;align-items:center">
            <div>
              <i class="fas fa-<?= Helpers::e($c['icon'] ?? 'tag') ?> text-muted"></i>
              <strong><?= Helpers::e($c['name']) ?></strong>
              <code class="text-muted"><?= Helpers::e($c['slug']) ?></code>
            </div>
            <span class="status-badge <?= !empty($c['visible']) ? 'status-approved' : 'status-hidden' ?>"><?= !empty($c['visible']) ? 'Visible' : 'Oculta' ?></span>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>
