<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs" class="active"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-terminal"></i> Logs del sistema</h1>
    </div>

    <?php foreach($logs as $name => $rows): ?>
    <div class="admin-card" style="margin-bottom:1rem">
      <h3><i class="fas fa-file-code"></i> <?= Helpers::e($name) ?> <small class="text-muted">(<?= count($rows) ?> líneas)</small></h3>
      <div class="log-viewer">
        <?php if (empty($rows)): ?>
        <p class="text-muted">Sin registros.</p>
        <?php else: ?>
        <pre class="log-pre"><?= Helpers::e(implode("\n", array_slice($rows, -100))) ?></pre>
        <?php endif; ?>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>
