<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas" class="active"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-file-alt"></i> Páginas dinámicas</h1>
    </div>

    <div class="admin-card">
      <h3><i class="fas fa-plus"></i> Crear nueva página</h3>
      <form method="post" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <label class="form-label">Título</label>
          <input name="title" placeholder="Ej: Acerca de, Términos, Privacidad..." required>
        </div>
        <div class="form-group">
          <label class="form-label">Contenido</label>
          <textarea name="content" rows="8" placeholder="Escribe el contenido de la página..."></textarea>
        </div>
        <button type="submit"><i class="fas fa-save"></i> Crear página</button>
      </form>
    </div>

    <div class="admin-card" style="margin-top:1rem">
      <h3>Páginas existentes (<?= count($pages) ?>)</h3>
      <?php if (empty($pages)): ?>
      <p class="text-muted" style="margin-top:.5rem">No hay páginas creadas aún.</p>
      <?php else: ?>
      <div class="data-list" style="margin-top:1rem">
        <?php foreach($pages as $p): ?>
        <div class="data-item">
          <div class="data-item-body" style="display:flex;justify-content:space-between;align-items:center">
            <div>
              <i class="fas fa-file-alt text-muted"></i>
              <strong><?= Helpers::e($p['title']) ?></strong>
              <code class="text-muted">/pagina/<?= Helpers::e($p['slug']) ?></code>
            </div>
            <a href="/pagina/<?= Helpers::e($p['slug']) ?>" target="_blank" class="btn-sm btn-outline"><i class="fas fa-external-link-alt"></i> Ver</a>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
