<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-shield-halved"></i> Panel Admin</div>
    <nav class="admin-nav">
      <a href="/admin"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/admin/publicaciones?estado=pending"><i class="fas fa-clipboard-check"></i> Moderación</a>
      <a href="/admin/usuarios" class="active"><i class="fas fa-users"></i> Usuarios</a>
      <a href="/admin/categorias"><i class="fas fa-folder-tree"></i> Categorías</a>
      <a href="/admin/publicidad"><i class="fas fa-ad"></i> Publicidad</a>
      <a href="/admin/paginas"><i class="fas fa-file-alt"></i> Páginas</a>
      <a href="/admin/reportes"><i class="fas fa-flag"></i> Reportes</a>
      <a href="/admin/logs"><i class="fas fa-terminal"></i> Logs</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-users"></i> Gestión de usuarios</h1>
    </div>

    <div class="admin-card">
      <div class="table-responsive">
        <table class="admin-table">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nombre</th>
              <th>Email</th>
              <th>Rol</th>
              <th>Estado</th>
              <th>Registro</th>
              <th>Acciones</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($users as $u): ?>
            <tr>
              <td><code><?= Helpers::e(substr($u['id'], 0, 12)) ?></code></td>
              <td><?= Helpers::e($u['name']) ?></td>
              <td><?= Helpers::e($u['email']) ?></td>
              <td><span class="status-badge status-<?= $u['role'] === 'superadmin' ? 'approved' : ($u['role'] === 'admin' ? 'pending' : 'hidden') ?>"><?= Helpers::e(ucfirst($u['role'])) ?></span></td>
              <td><span class="status-badge status-<?= ($u['status'] ?? 'active') === 'active' ? 'approved' : 'blocked' ?>"><?= Helpers::e(ucfirst($u['status'] ?? 'active')) ?></span></td>
              <td><?= date('d/m/Y', (int)($u['createdAt'] ?? 0)) ?></td>
              <td>
                <form class="inline-form" method="post" action="/admin/usuarios">
                  <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
                  <input type="hidden" name="id" value="<?= Helpers::e($u['id']) ?>">
                  <?php if (($u['status'] ?? 'active') === 'active'): ?>
                  <button name="action" value="block" class="btn-sm btn-danger"><i class="fas fa-ban"></i> Bloquear</button>
                  <?php else: ?>
                  <button name="action" value="unblock" class="btn-sm btn-success"><i class="fas fa-check"></i> Desbloquear</button>
                  <?php endif; ?>
                </form>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
