<?php use App\Core\Helpers; ?>

<div class="auth-container">
  <div class="auth-card">
    <div class="auth-header">
      <div class="auth-icon"><i class="fas fa-user-plus"></i></div>
      <h1>Crear cuenta</h1>
      <p class="text-muted">Únete al marketplace y comienza a vender</p>
    </div>
    <form method="post">
      <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
      <div class="form-group">
        <label class="form-label"><i class="fas fa-user"></i> Nombre completo</label>
        <input name="name" placeholder="Tu nombre" required autofocus>
      </div>
      <div class="form-group">
        <label class="form-label"><i class="fas fa-envelope"></i> Correo electrónico</label>
        <input name="email" type="email" placeholder="tu@correo.com" required>
      </div>
      <div class="form-grid">
        <div class="form-group">
          <label class="form-label"><i class="fas fa-phone"></i> Teléfono</label>
          <input name="phone" placeholder="+591...">
        </div>
        <div class="form-group">
          <label class="form-label"><i class="fab fa-whatsapp"></i> WhatsApp</label>
          <input name="whatsapp" placeholder="+591...">
        </div>
      </div>
      <div class="form-group">
        <label class="form-label"><i class="fas fa-map-marker-alt"></i> Ubicación</label>
        <input name="location" placeholder="Cochabamba, La Paz...">
      </div>
      <div class="form-group">
        <label class="form-label"><i class="fas fa-lock"></i> Contraseña (mín. 8 caracteres)</label>
        <input name="password" type="password" placeholder="Contraseña segura" required minlength="8">
      </div>
      <button type="submit" class="btn-block"><i class="fas fa-user-plus"></i> Registrarme</button>
    </form>
    <div class="auth-footer">
      <p>¿Ya tienes cuenta? <a href="/login"><strong>Iniciar sesión</strong></a></p>
    </div>
  </div>
</div>
