<?php use App\Core\Helpers; $me = $auth->user(); $cats = (new \App\Core\Marketplace($storage))->getCategories(); ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= Helpers::e(($title ?? 'Marketplace') . ' | ' . $config['app']['name']) ?></title>
  <meta name="description" content="<?= Helpers::e($metaDescription ?? 'Marketplace de Venta y Compra - Taller Mecánico Mojarra. Vehículos, repuestos y más.') ?>">
  <meta property="og:title" content="<?= Helpers::e($title ?? 'Inicio') ?> | <?= Helpers::e($config['app']['name']) ?>">
  <meta property="og:description" content="<?= Helpers::e($metaDescription ?? 'Marketplace de compra y venta en Bolivia') ?>">
  <meta property="og:site_name" content="Venta y Compra - Taller Mecánico Mojarra">
  <meta property="og:type" content="website">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link rel="stylesheet" href="/assets/css/styles.css">
</head>
<body>
<header class="navbar" id="navbar">
  <div class="navbar-inner">
    <a class="brand" href="/">
      <span class="brand-icon"><i class="fas fa-wrench"></i></span>
      <span class="brand-text">Venta y Compra <span class="brand-sub">– Taller Mecánico Mojarra</span></span>
    </a>
    <form action="/buscar" method="get" class="nav-search">
      <i class="fas fa-search nav-search-icon"></i>
      <input type="text" name="q" placeholder="Buscar vehículos, repuestos, ropa..." autocomplete="off" value="<?= Helpers::e($_GET['q'] ?? '') ?>">
      <button type="submit"><i class="fas fa-arrow-right"></i></button>
    </form>
    <button class="mobile-toggle" id="menuToggle" aria-label="Menú"><i class="fas fa-bars"></i></button>
    <nav class="nav-links" id="navLinks">
      <div class="nav-categories-dropdown">
        <button type="button" class="nav-dd-btn"><i class="fas fa-th-large"></i> Categorías <i class="fas fa-chevron-down fa-xs"></i></button>
        <div class="mega-menu" id="megaMenu">
          <div class="mega-grid">
            <?php foreach ($cats as $c): ?>
            <a href="/categoria/<?= Helpers::e($c['slug']) ?>" class="mega-item">
              <i class="fas fa-<?= Helpers::e($c['icon'] ?? 'tag') ?>"></i>
              <span><?= Helpers::e($c['name']) ?></span>
            </a>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <a href="/buscar?cat=autos" class="nav-link"><i class="fas fa-car"></i> Vehículos</a>
      <a href="/buscar?cat=repuestos" class="nav-link"><i class="fas fa-cogs"></i> Repuestos</a>
      <?php if ($me): ?>
        <a href="/panel" class="nav-link"><i class="fas fa-user-circle"></i> Panel</a>
        <?php if (in_array($me['role'], ['admin','superadmin'], true)): ?>
          <a href="/admin" class="nav-link nav-admin"><i class="fas fa-shield-halved"></i> Admin</a>
        <?php endif; ?>
        <?php if ($me['role'] === 'superadmin'): ?>
          <a href="/superadmin/config" class="nav-link nav-super"><i class="fas fa-crown"></i> Super</a>
        <?php endif; ?>
        <form action="/logout" method="post" class="nav-logout-form">
          <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
          <button type="submit" class="nav-link nav-logout"><i class="fas fa-sign-out-alt"></i> Salir</button>
        </form>
      <?php else: ?>
        <a href="/login" class="nav-link"><i class="fas fa-sign-in-alt"></i> Ingresar</a>
        <a href="/registro" class="nav-link btn-glow"><i class="fas fa-user-plus"></i> Crear cuenta</a>
      <?php endif; ?>
    </nav>
  </div>
</header>
<main class="main-content">
  <div class="container">
    <?php if ($msg = Helpers::flash('success')): ?>
    <div class="flash flash-success" id="flashMsg">
      <i class="fas fa-check-circle"></i> <span><?= Helpers::e($msg) ?></span>
      <button type="button" class="flash-close" onclick="this.parentElement.remove()"><i class="fas fa-times"></i></button>
    </div>
    <?php endif; ?>
    <?php if ($msg = Helpers::flash('error')): ?>
    <div class="flash flash-error" id="flashMsg">
      <i class="fas fa-exclamation-triangle"></i> <span><?= Helpers::e($msg) ?></span>
      <button type="button" class="flash-close" onclick="this.parentElement.remove()"><i class="fas fa-times"></i></button>
    </div>
    <?php endif; ?>
    <?= $content ?>
  </div>
</main>
<footer class="site-footer">
  <div class="container">
    <div class="footer-grid">
      <div class="footer-col">
        <h4><i class="fas fa-wrench"></i> Taller Mecánico Mojarra</h4>
        <p>Marketplace profesional de compra y venta. Especialistas en vehículos y repuestos.</p>
      </div>
      <div class="footer-col">
        <h4>Categorías</h4>
        <div class="footer-links">
          <a href="/buscar?cat=autos">Autos</a><a href="/buscar?cat=motos">Motos</a>
          <a href="/buscar?cat=repuestos">Repuestos</a><a href="/buscar?cat=llantas">Llantas</a>
          <a href="/buscar?cat=electrodomesticos">Electrodomésticos</a><a href="/buscar?cat=computadoras">Computadoras</a>
        </div>
      </div>
      <div class="footer-col">
        <h4>Información</h4>
        <div class="footer-links">
          <a href="/pagina/acerca-de">Acerca de</a><a href="/pagina/terminos">Términos</a>
          <a href="/pagina/privacidad">Privacidad</a><a href="/pagina/contacto">Contacto</a><a href="/pagina/ayuda">Ayuda</a>
        </div>
      </div>
      <div class="footer-col">
        <h4>Cuenta</h4>
        <div class="footer-links">
          <?php if ($me): ?>
            <a href="/panel">Mi Panel</a><a href="/panel/publicacion/nueva">Publicar</a><a href="/panel/perfil">Mi Perfil</a>
          <?php else: ?>
            <a href="/login">Iniciar sesión</a><a href="/registro">Crear cuenta</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="footer-bottom">
      <p>&copy; <?= date('Y') ?> Venta y Compra &ndash; Taller Mecánico Mojarra. Todos los derechos reservados.</p>
    </div>
  </div>
</footer>
<div class="modal-overlay" id="modalOverlay">
  <div class="modal-box" id="modalBox">
    <button class="modal-close" id="modalClose"><i class="fas fa-times"></i></button>
    <div class="modal-content" id="modalContent"></div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
