<?php use App\Core\Helpers; ?>

<div class="panel-layout">
  <aside class="panel-sidebar">
    <div class="panel-user-info">
      <div class="panel-avatar">
        <?php if (!empty($user['avatar'])): ?>
        <img src="/media/avatar/<?= Helpers::e($user['id']) ?>/<?= Helpers::e($user['avatar']) ?>" alt="Avatar">
        <?php else: ?>
        <div class="avatar-placeholder"><i class="fas fa-user"></i></div>
        <?php endif; ?>
      </div>
      <h3><?= Helpers::e($user['name']) ?></h3>
      <p class="text-muted"><?= Helpers::e($user['email']) ?></p>
    </div>
    <nav class="panel-nav">
      <a href="/panel" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/panel/publicaciones"><i class="fas fa-list"></i> Mis publicaciones</a>
      <a href="/panel/publicacion/nueva"><i class="fas fa-plus-circle"></i> Nueva publicación</a>
      <a href="/panel/perfil"><i class="fas fa-user-edit"></i> Editar perfil</a>
      <a href="/panel/cambiar-clave"><i class="fas fa-key"></i> Cambiar contraseña</a>
    </nav>
  </aside>

  <div class="panel-main">
    <h1><i class="fas fa-tachometer-alt"></i> Panel de vendedor</h1>

    <div class="stats-grid">
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--primary)"><i class="fas fa-list-alt"></i></div>
        <div class="stat-number"><?= count($items) ?></div>
        <div class="stat-label">Publicaciones</div>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--accent)"><i class="fas fa-heart"></i></div>
        <div class="stat-number"><?= (int)$favoritesCount ?></div>
        <div class="stat-label">Favoritos</div>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--secondary)"><i class="fas fa-eye"></i></div>
        <div class="stat-number"><?= (int)$viewsTotal ?></div>
        <div class="stat-label">Vistas totales</div>
      </div>
      <div class="stat-card">
        <div class="stat-icon" style="color:var(--warning)"><i class="fas fa-clock"></i></div>
        <div class="stat-number"><?= count(array_filter($items, fn($x) => ($x['status'] ?? '') === 'pending')) ?></div>
        <div class="stat-label">Pendientes</div>
      </div>
    </div>

    <div class="section">
      <div class="section-header">
        <h2><i class="fas fa-bell"></i> Notificaciones</h2>
      </div>
      <?php if (empty($notifications)): ?>
      <p class="text-muted">No tienes notificaciones nuevas.</p>
      <?php else: ?>
      <div class="data-list">
        <?php foreach(array_slice(array_reverse($notifications), 0, 10) as $n): ?>
        <div class="data-item">
          <div class="data-item-body">
            <i class="fas fa-bell text-muted"></i>
            <span><?= Helpers::e($n['message']) ?></span>
            <small class="text-muted"><?= date('d/m/Y H:i', (int)$n['createdAt']) ?></small>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
