<?php use App\Core\Helpers; $user = $auth->user(); ?>

<div class="panel-layout">
  <aside class="panel-sidebar">
    <div class="panel-user-info">
      <div class="panel-avatar"><div class="avatar-placeholder"><i class="fas fa-user"></i></div></div>
      <h3><?= Helpers::e($user['name'] ?? '') ?></h3>
    </div>
    <nav class="panel-nav">
      <a href="/panel"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/panel/publicaciones" class="active"><i class="fas fa-list"></i> Mis publicaciones</a>
      <a href="/panel/publicacion/nueva"><i class="fas fa-plus-circle"></i> Nueva publicación</a>
      <a href="/panel/perfil"><i class="fas fa-user-edit"></i> Editar perfil</a>
      <a href="/panel/cambiar-clave"><i class="fas fa-key"></i> Cambiar contraseña</a>
    </nav>
  </aside>

  <div class="panel-main">
    <div class="section-header">
      <h1><i class="fas fa-list"></i> Mis publicaciones</h1>
      <a href="/panel/publicacion/nueva" class="btn-glow"><i class="fas fa-plus"></i> Nueva publicación</a>
    </div>

    <?php if (empty($items)): ?>
    <div class="empty-state">
      <i class="fas fa-inbox"></i>
      <h3>No tienes publicaciones aún</h3>
      <p>Crea tu primera publicación y comienza a vender.</p>
      <a href="/panel/publicacion/nueva" class="btn-glow"><i class="fas fa-plus"></i> Crear publicación</a>
    </div>
    <?php else: ?>
    <div class="data-list">
      <?php foreach($items as $it): ?>
      <div class="data-item">
        <div class="data-item-header">
          <div>
            <h3><?= Helpers::e($it['title']) ?></h3>
            <div class="data-item-meta">
              <span class="status-badge status-<?= Helpers::e($it['status'] ?? 'pending') ?>"><?= Helpers::e(ucfirst($it['status'] ?? 'pending')) ?></span>
              <span class="text-muted"><i class="fas fa-folder"></i> <?= Helpers::e(ucfirst($it['category'] ?? '')) ?></span>
              <span class="text-muted"><i class="fas fa-eye"></i> <?= (int)($it['views'] ?? 0) ?></span>
            </div>
          </div>
          <div class="listing-card-price"><?= number_format((float)($it['price'] ?? 0), 0, ',', '.') ?> BOB</div>
        </div>
        <div class="data-item-actions">
          <a href="/panel/publicacion/editar?id=<?= Helpers::e($it['id']) ?>" class="btn-sm btn-outline"><i class="fas fa-edit"></i> Editar</a>
          <a href="/producto/<?= Helpers::e($it['id']) ?>/<?= Helpers::e($it['slug'] ?? 'item') ?>" class="btn-sm btn-outline" target="_blank"><i class="fas fa-eye"></i> Ver</a>
          <?php if (in_array($it['status'] ?? '', ['pending', 'rejected'], true)): ?>
          <form class="inline-form" data-confirm="¿Eliminar esta publicación?" action="/panel/publicacion/eliminar?id=<?= Helpers::e($it['id']) ?>" method="post">
            <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
            <button type="submit" class="btn-sm btn-danger"><i class="fas fa-trash"></i> Eliminar</button>
          </form>
          <?php endif; ?>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
    <?php endif; ?>
  </div>
</div>
