<?php use App\Core\Helpers; ?>

<div class="panel-layout">
  <aside class="panel-sidebar">
    <div class="panel-user-info">
      <div class="panel-avatar">
        <?php if (!empty($user['avatar'])): ?>
        <img src="/media/avatar/<?= Helpers::e($user['id']) ?>/<?= Helpers::e($user['avatar']) ?>" alt="Avatar">
        <?php else: ?>
        <div class="avatar-placeholder"><i class="fas fa-user"></i></div>
        <?php endif; ?>
      </div>
      <h3><?= Helpers::e($user['name']) ?></h3>
      <p class="text-muted"><?= Helpers::e($user['email']) ?></p>
    </div>
    <nav class="panel-nav">
      <a href="/panel"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
      <a href="/panel/publicaciones"><i class="fas fa-list"></i> Mis publicaciones</a>
      <a href="/panel/publicacion/nueva"><i class="fas fa-plus-circle"></i> Nueva publicación</a>
      <a href="/panel/perfil" class="active"><i class="fas fa-user-edit"></i> Editar perfil</a>
      <a href="/panel/cambiar-clave"><i class="fas fa-key"></i> Cambiar contraseña</a>
    </nav>
  </aside>

  <div class="panel-main">
    <h1><i class="fas fa-user-edit"></i> Mi perfil</h1>
    <div class="form-card">
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-group">
          <label class="form-label"><i class="fas fa-user"></i> Nombre completo</label>
          <input name="name" value="<?= Helpers::e($user['name']) ?>" required>
        </div>
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label"><i class="fas fa-phone"></i> Teléfono</label>
            <input name="phone" value="<?= Helpers::e($user['phone'] ?? '') ?>" placeholder="+591...">
          </div>
          <div class="form-group">
            <label class="form-label"><i class="fab fa-whatsapp"></i> WhatsApp</label>
            <input name="whatsapp" value="<?= Helpers::e($user['whatsapp'] ?? '') ?>" placeholder="+591...">
          </div>
        </div>
        <div class="form-group">
          <label class="form-label"><i class="fas fa-map-marker-alt"></i> Ubicación</label>
          <input name="location" value="<?= Helpers::e($user['location'] ?? '') ?>" placeholder="Ciudad, Departamento">
        </div>
        <div class="form-group">
          <label class="form-label"><i class="fas fa-camera"></i> Foto de perfil</label>
          <input type="file" name="avatar" accept="image/*">
        </div>
        <button type="submit"><i class="fas fa-save"></i> Guardar perfil</button>
      </form>
    </div>
  </div>
</div>
