<?php use App\Core\Helpers; ?>

<!-- Hero Section -->
<section class="hero">
  <div class="hero-bg"></div>
  <div class="hero-content">
    <h1>Marketplace de <span class="text-glow">Vehículos y Repuestos</span></h1>
    <p>Compra, vende e intercambia de forma segura. Moderación profesional en cada publicación.</p>
    <form action="/buscar" method="get" class="hero-search-form">
      <div class="hero-search-row">
        <div class="hero-input-wrap">
          <i class="fas fa-search"></i>
          <input type="text" name="q" placeholder="¿Qué estás buscando hoy?">
        </div>
        <select name="cat">
          <option value="">Todas las categorías</option>
          <?php foreach ($categories as $c): ?>
          <option value="<?= Helpers::e($c['slug']) ?>"><?= Helpers::e($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <button type="submit"><i class="fas fa-search"></i> Explorar</button>
      </div>
    </form>
  </div>
</section>

<!-- Quick Categories -->
<section class="quick-categories">
  <?php
  $catIcons = [
    'autos' => 'car', 'motos' => 'motorcycle', 'motores' => 'gear',
    'repuestos' => 'cogs', 'llantas' => 'circle', 'faros' => 'lightbulb',
    'herramientas' => 'wrench', 'ropa' => 'shirt', 'electrodomesticos' => 'blender',
    'computadoras' => 'laptop', 'muebles' => 'couch', 'zapatillas' => 'shoe-prints',
  ];
  foreach (array_slice($categories, 0, 8) as $c):
    $icon = $catIcons[$c['slug']] ?? ($c['icon'] ?? 'tag');
  ?>
  <a href="/categoria/<?= Helpers::e($c['slug']) ?>" class="quick-cat-item">
    <div class="quick-cat-icon"><i class="fas fa-<?= Helpers::e($icon) ?>"></i></div>
    <span><?= Helpers::e($c['name']) ?></span>
  </a>
  <?php endforeach; ?>
</section>

<!-- Vehicles & Parts Priority Section -->
<?php if (!empty($vehicles)): ?>
<section class="section">
  <div class="section-header">
    <h2><i class="fas fa-car-side"></i> Vehículos y Repuestos</h2>
    <a href="/buscar?cat=autos" class="section-link">Ver todos <i class="fas fa-arrow-right"></i></a>
  </div>
  <div class="grid-cards">
    <?php foreach ($vehicles as $it) { require __DIR__ . '/../partials/listing_card.php'; } ?>
  </div>
</section>
<?php endif; ?>

<!-- Latest Listings -->
<section class="section">
  <div class="section-header">
    <h2><i class="fas fa-bolt"></i> Novedades</h2>
    <a href="/buscar" class="section-link">Ver catálogo completo <i class="fas fa-arrow-right"></i></a>
  </div>
  <div class="grid-cards">
    <?php foreach ($items as $it) { require __DIR__ . '/../partials/listing_card.php'; } ?>
  </div>
</section>

<!-- Skeleton Loaders Demo -->
<section class="section">
  <div class="grid-cards">
    <div class="skeleton-card"><div class="skeleton" style="height:180px"></div><div class="skeleton-text"></div><div class="skeleton-text" style="width:60%"></div></div>
    <div class="skeleton-card"><div class="skeleton" style="height:180px"></div><div class="skeleton-text"></div><div class="skeleton-text" style="width:60%"></div></div>
    <div class="skeleton-card"><div class="skeleton" style="height:180px"></div><div class="skeleton-text"></div><div class="skeleton-text" style="width:60%"></div></div>
    <div class="skeleton-card"><div class="skeleton" style="height:180px"></div><div class="skeleton-text"></div><div class="skeleton-text" style="width:60%"></div></div>
  </div>
</section>
