<?php use App\Core\Helpers; ?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <div class="admin-brand"><i class="fas fa-crown"></i> SuperAdmin</div>
    <nav class="admin-nav">
      <a href="/superadmin/admins" class="active"><i class="fas fa-user-shield"></i> Gestión de Admins</a>
      <a href="/superadmin/config"><i class="fas fa-sliders-h"></i> Configuración</a>
      <a href="/admin"><i class="fas fa-arrow-left"></i> Volver a Admin</a>
    </nav>
  </aside>

  <div class="admin-main">
    <div class="admin-header">
      <h1><i class="fas fa-user-shield"></i> Gestión de Administradores</h1>
    </div>

    <!-- Create Admin -->
    <div class="admin-card">
      <h3><i class="fas fa-user-plus"></i> Crear nuevo administrador</h3>
      <form method="post" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Nombre</label>
            <input name="name" placeholder="Nombre del admin" required>
          </div>
          <div class="form-group">
            <label class="form-label">Email</label>
            <input name="email" type="email" placeholder="admin@dominio.com" required>
          </div>
          <div class="form-group">
            <label class="form-label">Contraseña inicial</label>
            <input name="password" type="password" value="Cambiar123!" required>
          </div>
        </div>
        <button type="submit"><i class="fas fa-user-plus"></i> Crear Admin</button>
      </form>
    </div>

    <!-- Admin List -->
    <div class="admin-card" style="margin-top:1.5rem">
      <h3>Administradores actuales (<?= count($admins) ?>)</h3>
      <div class="table-responsive" style="margin-top:1rem">
        <table class="admin-table">
          <thead>
            <tr>
              <th>ID</th>
              <th>Email</th>
              <th>Rol</th>
              <th>Estado</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($admins as $a): ?>
            <tr>
              <td><code><?= Helpers::e($a['id']) ?></code></td>
              <td><?= Helpers::e($a['email']) ?></td>
              <td><span class="status-badge status-<?= $a['role'] === 'superadmin' ? 'approved' : 'pending' ?>"><?= Helpers::e(ucfirst($a['role'])) ?></span></td>
              <td><span class="status-badge status-<?= ($a['status'] ?? 'active') === 'active' ? 'approved' : 'blocked' ?>"><?= Helpers::e(ucfirst($a['status'] ?? 'active')) ?></span></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Reset Password -->
    <div class="admin-card" style="margin-top:1.5rem">
      <h3><i class="fas fa-key"></i> Resetear contraseña de usuario</h3>
      <form method="post" action="/superadmin/reset-password" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">ID del usuario</label>
            <input name="user_id" placeholder="u_xxxxxxxxxxxx" required>
          </div>
          <div class="form-group">
            <label class="form-label">Nueva contraseña</label>
            <input name="new_password" type="password" placeholder="Mín. 8 caracteres" required minlength="8">
          </div>
        </div>
        <button type="submit" class="btn-warning"><i class="fas fa-key"></i> Resetear contraseña</button>
      </form>
    </div>

    <!-- Backup -->
    <div class="admin-card" style="margin-top:1.5rem">
      <h3><i class="fas fa-database"></i> Backup rápido</h3>
      <form method="post" action="/superadmin/backup/crear" style="margin-top:1rem">
        <input type="hidden" name="_csrf" value="<?= Helpers::e($security->csrfToken()) ?>">
        <button type="submit"><i class="fas fa-download"></i> Crear backup ahora</button>
      </form>
    </div>
  </div>
</div>
