﻿# Venta y Compra - Taller Mecanico Mojarra

Marketplace file-based (sin SQL) con PHP + HTML/CSS/JS, pensado para cPanel.

## 1) Requisitos
- PHP 8.1+
- Extensiones: `json`, `mbstring`, `fileinfo`, `zip`
- `mod_rewrite` habilitado

## 2) Estructura
- `public/` entrada web
- `app/` nucleo, controladores, vistas
- `storage/` persistencia JSON + imagenes + logs + backups
- `scripts/seed.php` datos de prueba (50 usuarios + 150 publicaciones)

## 3) Instalacion cPanel
1. Subir proyecto completo.
2. Configurar dominio para que el document root apunte a `public/`.
3. Si no es posible, mover contenido de `public/` a `public_html/` y ajustar rutas de `app/config.php`.
4. Dar permisos de escritura a `storage/` (755/775 segun hosting).
5. Verificar `.htaccess` en `public/`.
6. Activar HTTPS desde cPanel (AutoSSL).
7. Editar `app/config.php` (nombre, moneda, items por pagina, etc.).
8. Ejecutar seed por terminal cPanel: `php scripts/seed.php`.

## 4) Credenciales seed
- SuperAdmin: `superadmin@mojarra.local` / `Cambiar123!`
- Admin: `admin@mojarra.local` / `Cambiar123!`

## 5) Flujo de moderacion
Registro -> Publicacion (pending) -> Admin aprueba/rechaza -> visible en publico.

## 6) Seguridad implementada
- Password hash (`password_hash` bcrypt)
- CSRF en formularios
- Rate limit por IP (login/registro)
- Validacion server-side
- Sanitizacion de salida (`htmlspecialchars`)
- Validacion de imagen por MIME + `getimagesize`
- Autorizacion por rol en endpoints
- Logs `app.log`, `auth.log`, `admin.log`
- Backups ZIP de `storage/`

## 7) Backups
Superadmin -> crear backup ZIP y restaurar desde panel.

## 8) Notas
- No usa MySQL/PostgreSQL/SQLite.
- Persistencia 100% JSON + archivos.
- Preparado para extender categorias y paginas desde admin.
