<?php
require __DIR__ . '/../app/bootstrap.php';

use App\Core\Auth;
use App\Core\Helpers;
use App\Core\Marketplace;
use App\Core\Storage;

$config = require __DIR__ . '/../app/config.php';
$storage = new Storage($config);
$auth = new Auth($storage, $config);
$market = new Marketplace($storage);

function rr(array $arr) { return $arr[array_rand($arr)]; }

$locations = ['Cochabamba', 'La Paz', 'Santa Cruz', 'Oruro', 'Tarija', 'Sucre', 'Potosi'];
$categories = ['motores','repuestos','autos','motos','llantas','valvulas','pernos','faros','accesorios','herramientas','ropa','zapatillas','electrodomesticos','computadoras','muebles','otros'];
$titles = [
    'Motor Toyota 2.7', 'Caja de cambios Nissan', 'Auto usado Suzuki', 'Moto Honda XR', 'Juego de llantas 17',
    'Valvula de escape', 'Pernos de rueda reforzados', 'Faro delantero LED', 'Chaqueta de trabajo',
    'Zapatillas deportivas nuevas', 'Microondas Samsung', 'Laptop Dell i7', 'Escritorio de madera', 'Taladro industrial'
];
$tags = ['motor','toyota','repuesto','moto','auto','llanta','herramienta','ropa','electro','pc'];

$usersCreated = 0;
$listingsCreated = 0;
$pending = 0;
$approved = 0;

$storage->writeJson('users/users.json', ['items' => []]);
$storage->writeJson('listings/listings.json', ['items' => []]);

$superId = $auth->register([
    'name' => 'Superadmin Mojarra',
    'email' => 'superadmin@mojarra.local',
    'phone' => '+59170000001',
    'whatsapp' => '+59170000001',
    'location' => 'Cochabamba',
    'password' => 'Cambiar123!',
    'role' => 'superadmin',
    'forcePasswordChange' => true,
]);
$usersCreated++;

$adminId = $auth->register([
    'name' => 'Admin Mojarra',
    'email' => 'admin@mojarra.local',
    'phone' => '+59170000002',
    'whatsapp' => '+59170000002',
    'location' => 'La Paz',
    'password' => 'Cambiar123!',
    'role' => 'admin',
    'forcePasswordChange' => true,
]);
$usersCreated++;

$userIds = [$superId, $adminId];
for ($i = 1; $i <= 48; $i++) {
    $id = $auth->register([
        'name' => 'Usuario Demo ' . $i,
        'email' => 'usuario' . $i . '@demo.local',
        'phone' => '+5917' . str_pad((string)rand(1000000, 9999999), 7, '0', STR_PAD_LEFT),
        'whatsapp' => '+5917' . str_pad((string)rand(1000000, 9999999), 7, '0', STR_PAD_LEFT),
        'location' => rr($locations),
        'password' => 'ClaveDemo123!',
        'role' => 'user',
    ]);
    $userIds[] = $id;
    $usersCreated++;
}

$demoImgs = glob(__DIR__ . '/../public/assets/img/demo/*.jpg') ?: [];
if (!$demoImgs) {
    echo "No hay imágenes demo en /public/assets/img/demo\n";
    exit(1);
}

foreach ($userIds as $u) {
    for ($j = 0; $j < 3; $j++) {
        $title = rr($titles);
        $status = rand(1, 100) <= 70 ? 'pending' : 'approved';
        $itemId = Helpers::randomId('l');

        $imgCount = rand(1, 3);
        $imgNames = [];
        $dir = $storage->path('listings/' . $itemId . '/images');
        if (!is_dir($dir)) mkdir($dir, 0775, true);

        for ($k = 0; $k < $imgCount; $k++) {
            $src = rr($demoImgs);
            $name = bin2hex(random_bytes(5)) . '.jpg';
            copy($src, $dir . DIRECTORY_SEPARATOR . $name);
            $imgNames[] = $name;
        }

        $listing = [
            'id' => $itemId,
            'ownerId' => $u,
            'title' => $title,
            'slug' => Helpers::slug($title . '-' . rand(10, 999)),
            'category' => rr($categories),
            'subcategory' => '',
            'condition' => rand(0, 1) ? 'nuevo' : 'usado',
            'price' => rand(80, 60000),
            'currency' => 'BOB',
            'description' => 'Publicación demo generada por seed para pruebas de flujo, búsqueda y moderación.',
            'tags' => [rr($tags), rr($tags), rr($tags)],
            'location' => rr($locations),
            'images' => $imgNames,
            'status' => $status,
            'featured' => rand(1, 100) <= 8,
            'priority' => rand(0, 3),
            'views' => rand(0, 120),
            'offerType' => rand(0, 100) < 20 ? 'intercambio' : 'venta',
            'shipping' => rand(0, 1),
            'sellerVerified' => rand(0, 100) < 25,
            'createdAt' => time() - rand(1000, 86400 * 35),
            'updatedAt' => time() - rand(100, 86400 * 20),
            'moderation' => [
                'approvedBy' => $status === 'approved' ? $adminId : null,
                'rejectedReason' => null,
            ],
        ];

        $market->saveListing($listing);
        $listingsCreated++;
        if ($status === 'pending') $pending++; else $approved++;
    }
}

// Recreate categories with icons
$storage->writeJson('categories/categories.json', ['items' => [
    ['id' => 'c_motor', 'name' => 'Motores', 'slug' => 'motores', 'icon' => 'gear', 'visible' => true],
    ['id' => 'c_rep', 'name' => 'Repuestos', 'slug' => 'repuestos', 'icon' => 'cogs', 'visible' => true],
    ['id' => 'c_autos', 'name' => 'Autos', 'slug' => 'autos', 'icon' => 'car', 'visible' => true],
    ['id' => 'c_motos', 'name' => 'Motos', 'slug' => 'motos', 'icon' => 'motorcycle', 'visible' => true],
    ['id' => 'c_llantas', 'name' => 'Llantas', 'slug' => 'llantas', 'icon' => 'circle', 'visible' => true],
    ['id' => 'c_valv', 'name' => 'Valvulas', 'slug' => 'valvulas', 'icon' => 'valve', 'visible' => true],
    ['id' => 'c_pernos', 'name' => 'Pernos', 'slug' => 'pernos', 'icon' => 'screwdriver-wrench', 'visible' => true],
    ['id' => 'c_faros', 'name' => 'Faros', 'slug' => 'faros', 'icon' => 'lightbulb', 'visible' => true],
    ['id' => 'c_acc', 'name' => 'Accesorios', 'slug' => 'accesorios', 'icon' => 'puzzle-piece', 'visible' => true],
    ['id' => 'c_tools', 'name' => 'Herramientas', 'slug' => 'herramientas', 'icon' => 'wrench', 'visible' => true],
    ['id' => 'c_ropa', 'name' => 'Ropa', 'slug' => 'ropa', 'icon' => 'shirt', 'visible' => true],
    ['id' => 'c_zapat', 'name' => 'Zapatillas', 'slug' => 'zapatillas', 'icon' => 'shoe-prints', 'visible' => true],
    ['id' => 'c_elect', 'name' => 'Electrodomesticos', 'slug' => 'electrodomesticos', 'icon' => 'blender', 'visible' => true],
    ['id' => 'c_pc', 'name' => 'Computadoras', 'slug' => 'computadoras', 'icon' => 'laptop', 'visible' => true],
    ['id' => 'c_mueb', 'name' => 'Muebles', 'slug' => 'muebles', 'icon' => 'couch', 'visible' => true],
    ['id' => 'c_otros', 'name' => 'Otros', 'slug' => 'otros', 'icon' => 'ellipsis', 'visible' => true],
]]);

// Recreate pages
$storage->writeJson('pages/pages.json', ['items' => [
    ['id' => 'p_about', 'title' => 'Acerca de', 'slug' => 'acerca-de', 'content' => "Venta y Compra - Taller Mecanico Mojarra es un marketplace profesional que conecta compradores y vendedores con foco principal en vehiculos y repuestos automotrices.\n\nTambien puedes encontrar ropa, electronica, muebles y mucho mas.\n\nNuestra mision es ofrecer una plataforma segura, con moderacion profesional de cada publicacion antes de que sea visible al publico.\n\nUbicados en Bolivia, servimos a compradores y vendedores de todo el pais.", 'updatedAt' => time()],
    ['id' => 'p_terms', 'title' => 'Terminos y condiciones', 'slug' => 'terminos', 'content' => "Al usar esta plataforma aceptas las siguientes condiciones:\n\n1. Se prohibe publicar contenido ilegal, violento, sexual o fraudulento.\n2. Cada publicacion pasa por moderacion antes de ser visible.\n3. No se permiten datos sensibles (tarjetas, credenciales) en las descripciones.\n4. El equipo de administracion puede ocultar o eliminar publicaciones que violen las reglas.\n5. Los usuarios bloqueados no podran crear nuevas publicaciones.", 'updatedAt' => time()],
    ['id' => 'p_priv', 'title' => 'Politica de privacidad', 'slug' => 'privacidad', 'content' => "Protegemos tus datos personales segun las mejores practicas de seguridad:\n\n- Las contrasenas se almacenan con hash bcrypt.\n- Los correos electronicos no se muestran publicamente.\n- La comunicacion entre comprador y vendedor se realiza via WhatsApp o llamada directa.\n- No compartimos informacion con terceros.", 'updatedAt' => time()],
    ['id' => 'p_contact', 'title' => 'Contacto', 'slug' => 'contacto', 'content' => "Para consultas, sugerencias o reportes:\n\n- WhatsApp del administrador: +591 70000001\n- Correo: admin@mojarra.local\n- Horario de atencion: Lunes a Sabado, 8:00 - 18:00\n\nTambien puedes reportar publicaciones directamente desde la pagina del producto.", 'updatedAt' => time()],
    ['id' => 'p_help', 'title' => 'Ayuda', 'slug' => 'ayuda', 'content' => "Guia rapida para usar el marketplace:\n\n1. Crea una cuenta con tu correo y telefono.\n2. Publica tu producto con fotos, descripcion y precio.\n3. Tu publicacion sera revisada por un moderador.\n4. Recibiras una notificacion cuando sea aprobada o rechazada.\n5. Los compradores te contactaran por WhatsApp o llamada.\n\nSi tienes problemas, contacta al administrador.", 'updatedAt' => time()],
]]);

// Initialize settings
$storage->writeJson('pages/settings.json', ['maintenance_mode' => false, 'site_name' => 'Venta y Compra - Taller Mecanico Mojarra']);

// Initialize ads
$storage->writeJson('ads/ad_slots.json', ['slots' => [
    ['key' => 'home_top', 'type' => 'banner', 'enabled' => true, 'code' => ''],
    ['key' => 'listing_inline_1', 'type' => 'banner', 'enabled' => false, 'code' => ''],
    ['key' => 'sidebar_1', 'type' => 'adsense', 'enabled' => false, 'code' => ''],
    ['key' => 'product_detail', 'type' => 'banner', 'enabled' => false, 'code' => ''],
]]);

// Initialize reports
$storage->writeJson('reports/reports.json', ['items' => []]);

echo "Seed completado\n";
echo "Usuarios creados: {$usersCreated}\n";
echo "Publicaciones creadas: {$listingsCreated}\n";
echo "Pendientes: {$pending}\n";
echo "Aprobadas: {$approved}\n";
echo "Superadmin: superadmin@mojarra.local / Cambiar123!\n";
echo "Admin: admin@mojarra.local / Cambiar123!\n";
